<?php
function add_esxi_portgroup($argv) {
	/* check number of arguments */
	if(count($argv) != 5) {
		echo "Usage: add_esxi_portgroup ESXI_HOST ESXI_USERNAME ESXI_PASSWORD PORTGROUP_NAME VSWITCH_NAME\n";
		exit(1);
	}

	/* fetch arguments */
	$esxi_host = escapeshellarg($argv[0]);
	$esxi_username = escapeshellarg($argv[1]);
	$esxi_password = escapeshellarg($argv[2]);
	$portgroup_name = escapeshellarg($argv[3]);
	$vswitch_name = escapeshellarg($argv[4]);

	/* execute main function */
	unset($result_array);
	exec("vicfg-vswitch --server $esxi_host --username $esxi_username --password $esxi_password --check-pg $portgroup_name 2>&1", $result_array, $return_value);
	if($return_value != 0) {
		echo "vicfg-vswitch error\n";
		exit(1);
	}

	/* the portgroup already exist */
	if($result_array[0] == 1) {
		exit(0);
	}

	unset($result_array);
	exec("vicfg-vswitch --server $esxi_host --username $esxi_username --password $esxi_password --add-pg $portgroup_name $vswitch_name 2>&1", $result_array, $return_value);
	foreach($result_array as $line) {
		echo $line . "\n";
	}
	exit($return_value);
}

